<?php
    $groupIcons = [
        'Meta' => 'sliders-h',
        'Home Page' => 'house',
        'Footer' => 'shoe-prints',
        'Store' => 'money-bill',
        'News' => 'bullhorn',
        'Forum' => 'comments',
        'Keys' => 'key',
        'Design' => 'palette',
    ];
?>




<?php $__env->startSection('title', 'Site Configurations'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
    <div class="dashboard-header">
        <h1>Configuration Management</h1>
        <p>Manage and update system configurations by category</p>
    </div>

    <div class="settings-page">
        <div class="nav-tabs">
            <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($groupItem === 'Navigation'): ?> <?php continue; ?> <?php endif; ?>
                <div class="nav-item">
                    <a href="<?php echo e(route('admin.configurations.index', ['group' => $groupItem])); ?>" 
                       class="nav-link <?php echo e($group == $groupItem ? 'active' : ''); ?>">
                        <i class="fas fa-<?php echo e($groupIcons[$groupItem] ?? 'cog'); ?>"></i>
                        <?php echo e(ucfirst($groupItem)); ?>

                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="dashboard-card dashboard-card-full">
            <div class="dashboard-card-header">
                <h3><?php echo e(ucfirst($group)); ?> Settings</h3>
            </div>
            <div class="dashboard-card-body">

                <form action="<?php echo e(route('admin.configurations.batch-update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="group" value="<?php echo e($group); ?>">
                    
                    <div class="config-grid">
                        <?php $__empty_1 = true; $__currentLoopData = $configurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="config-item">
                                <div class="config-label">
                                    <label for="config-<?php echo e($config->id); ?>"><?php echo e($config->description); ?></label>
                                    <span class="config-key"><?php echo e($config->key); ?></span>
                                </div>
                                <div class="config-input">
                                    <?php if($config->type == 'boolean'): ?>
                                    <div class="toggle-switch">
                                        <input type="checkbox" name="configs[<?php echo e($config->id); ?>]" 
                                               id="config-<?php echo e($config->id); ?>" 
                                               value="1" <?php echo e($config->value == '1' ? 'checked' : ''); ?>

                                               class="toggle-switch-checkbox">
                                        <label for="config-<?php echo e($config->id); ?>" class="toggle-switch-label">
                                            <span class="toggle-switch-switch"></span>
                                        </label>
                                    </div>
                                    <?php elseif($config->type == 'json'): ?>
                                        <div class="json-editor">
                                            <textarea name="configs[<?php echo e($config->id); ?>]" id="config-<?php echo e($config->id); ?>"
                                                class="form-control json-textarea" rows="5"><?php echo e($config->value); ?></textarea>
                                            <div class="format-json-btn" data-target="config-<?php echo e($config->id); ?>">
                                                <i class="fas fa-code"></i> Format JSON
                                            </div>
                                        </div>
                                    <?php elseif($config->type == 'color'): ?>
                                        <div class="color-picker-wrapper">
                                            <input type="color" name="configs[<?php echo e($config->id); ?>]" id="config-<?php echo e($config->id); ?>"
                                                class="color-picker-input" value="<?php echo e($config->value ?? '#000000'); ?>">
                                            <input type="text" name="color_text_<?php echo e($config->id); ?>" id="color-text-<?php echo e($config->id); ?>"
                                                class="color-text-input form-control" value="<?php echo e($config->value ?? '#000000'); ?>">
                                        </div>
                                    <?php elseif($config->type == 'icon'): ?>
                                        <div class="icon-picker-wrapper">
                                            <div class="icon-picker-preview">
                                                <i class="fas fa-<?php echo e($config->value ?? 'question'); ?>" id="icon-preview-<?php echo e($config->id); ?>"></i>
                                            </div>
                                            <input type="text" name="configs[<?php echo e($config->id); ?>]" id="config-<?php echo e($config->id); ?>"
                                                class="icon-picker-input form-control" value="<?php echo e($config->value ?? ''); ?>" 
                                                placeholder="Search for an icon..." autocomplete="off">
                                            <div class="icon-picker-dropdown" id="icon-dropdown-<?php echo e($config->id); ?>">
                                                <div class="icon-picker-search">
                                                    <input type="text" id="icon-search-<?php echo e($config->id); ?>" 
                                                        class="icon-search-input form-control" placeholder="Search icons...">
                                                </div>
                                                <div class="icon-picker-list" id="icon-list-<?php echo e($config->id); ?>">
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    <?php elseif($config->type == 'select'): ?>
                                        <select name="configs[<?php echo e($config->id); ?>]" id="config-<?php echo e($config->id); ?>" class="form-control">
                                        <?php
                                            $optionsString = $config->options ?? '';
                                            $options = !empty($optionsString) ? explode(',', $optionsString) : [];
                                            $currentValue = $config->value ?? '';
                                        ?>
                                        
                                        <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $option = trim($option);
                                            ?>
                                            <option value="<?php echo e($option); ?>" <?php echo e($currentValue == $option ? 'selected' : ''); ?>>
                                                <?php echo e($option); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php elseif($config->type == 'file' || $config->type == 'image'): ?>
                                        <div class="file-upload-wrapper">
                                            <input type="file" name="file_configs[<?php echo e($config->id); ?>]" id="config-<?php echo e($config->id); ?>" 
                                                class="file-upload-input" data-max-size="2048">
                                            <label for="config-<?php echo e($config->id); ?>" class="file-upload-label">
                                                <span class="file-upload-icon"><i class="fas fa-upload"></i></span>
                                                <span class="file-upload-text">Choose file</span>
                                            </label>
                                            <div class="file-upload-preview">
                                                <?php if($config->value): ?>
                                                    <div class="current-file">
                                                        <span class="file-name">Current file</span>
                                                        <?php if(in_array(pathinfo($config->value, PATHINFO_EXTENSION), ['jpg', 'jpeg', 'png', 'gif', 'svg', 'ico'])): ?>
                                                            <img src="<?php echo e(asset($config->value)); ?>" alt="Current file" class="file-preview">
                                                        <?php else: ?>
                                                            <i class="fas fa-file"></i>
                                                        <?php endif; ?>
                                                        <input type="hidden" name="existing_files[<?php echo e($config->id); ?>]" value="<?php echo e($config->value); ?>">
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php elseif($config->type == 'text' && strlen($config->value) > 100): ?>
                                        <textarea name="configs[<?php echo e($config->id); ?>]" id="config-<?php echo e($config->id); ?>"
                                            class="form-control" rows="3"><?php echo e($config->value); ?></textarea>
                                    <?php else: ?>
                                        <input type="text" name="configs[<?php echo e($config->id); ?>]" id="config-<?php echo e($config->id); ?>"
                                            class="form-control" value="<?php echo e($config->value); ?>">
                                    <?php endif; ?>
                                    
                                    <?php if($config->type != 'checkbox'): ?>
                                        <div class="config-type"><?php echo e(ucfirst($config->type)); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="no-configs">
                                <i class="fas fa-exclamation-circle"></i>
                                <p>No configurations found for this category.</p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if(count($configurations) > 0): ?>
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Changes
                            </button>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Format JSON function
        document.querySelectorAll('.format-json-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const targetId = this.getAttribute('data-target');
                const textarea = document.getElementById(targetId);
                
                try {
                    const formatted = JSON.stringify(JSON.parse(textarea.value), null, 2);
                    textarea.value = formatted;
                } catch (e) {
                    alert('Invalid JSON format');
                }
            });
        });

        // File upload preview
        document.querySelectorAll('.file-upload-input').forEach(input => {
            input.addEventListener('change', function() {
                const fileName = this.files[0]?.name || '';
                const label = this.nextElementSibling.querySelector('.file-upload-text');
                const preview = this.parentElement.querySelector('.file-upload-preview');
                
                if (fileName) {
                    label.textContent = fileName;
                    
                    if (this.files[0] && this.files[0].type.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            preview.innerHTML = `
                                <div class="new-file">
                                    <span class="file-name">New file:</span>
                                    <img src="${e.target.result}" alt="File preview" class="file-preview">
                                </div>
                                ${preview.innerHTML}
                            `;
                        }
                        reader.readAsDataURL(this.files[0]);
                    }
                } else {
                    label.textContent = 'Choose file';
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/configurations/index.blade.php ENDPATH**/ ?>